<?php

public function actionCreate()
{
    $model = new Request();

    if ($model->load(Yii::$app->request->post()) && $model->save()) {
        return $this->redirect(['view', 'id' => $model->id]);
    } else {
        return $this->render('create', [
            'model' => $model,
            'manager' => Stuff::find()->all(),
            'movercompany' => MoverCompany::find()->all(),
            'worktype' => Worktype::find()->all(),
            'customer' => Customer::find()->all(),
        ]);
    }
}

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\bootstrap\Modal;

/* @var $this yii\web\View */
/* @var $model app\models\Request */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="request-form">

    <?php 
        $form = ActiveForm::begin();
        date_default_timezone_set("Europe/Moscow");
        $model->request_date = date('Y-m-d');
        $model->request_time = date('H:i');
    ?>

    <?= $form->field($model, 'request_date')->widget(\yii\jui\DatePicker::classname(), [
        'language' => 'ru',
        'dateFormat' => 'yyyy-MM-dd',
    ]) ?>

    <?= $form->field($model, 'request_time')->textInput(['style' => 'width: 70px;']) ?> 

    <?= $form->field($model, 'customer_id')->widget(Select2::classname(), [
        'data' => ArrayHelper::map($customer, 'id', 'fullInfo'),
        'language' => 'ru',
        'options' => ['placeholder' => 'Выбрать клиента...'],
        'pluginOptions' => [
            'allowClear' => true
        ],
    ]);?>

    <?= $form->field($model, 'KP_id')->textInput() ?>


    <?= $form->field($model, 'quantity')->input('number', ['style' => 'width: 75px;']) ?>
    <div>

        <?= $form->field($model, 'request_type')->dropDownList(
            ArrayHelper::map($worktype, 'id', 'title'),
            array('prompt' => 'Выберите вид работ:', 'style' => 'width: 200px;')
        ) ?>

        <?= Html::button('+', ['value' => Url::to('index.php?r=worktype/create'), 'class' => 'btn btn-success', 'id' => 'modalButton']) ?>

    </div>
    <?php
        Modal::begin([
                'header' => '<h4>Виды работ</h4>',
                'id' => 'modal',
                'size' => 'modal-lg',
            ]);
        echo "<div id='modalContent'></div>";
        Modal::end();
    ?>

    <?= $form->field($model, 'payment_type')->dropDownList(
        [
            '0' => 'Нал',
            '1' => 'Безнал'
        ], 
        ['style' => 'width: 80px;']) 
    ?>

    <?= $form->field($model, 'address')->textarea(['rows' => 2]) ?>

    <?= $form->field($model, 'minimal_payment')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'mover_company_id')->dropDownList(
        ArrayHelper::map($movercompany, 'id', 'name'),
        array('prompt' => 'Выберите компанию:', 'style' => 'width: 200px;')
    ) ?>

    <?= $form->field($model, 'manager_id')->dropDownList(
        ArrayHelper::map($manager, 'id', 'name'),
        array('prompt' => 'Выберите менеджера:', 'style' => 'width: 200px;')
    ) ?>

    <?= $form->field($model, 'workers_number')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'workhours')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'payment_additional')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'payment_car')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'payment_sum')->input('number', ['style' => 'width: 100px;']) ?>

    <?= $form->field($model, 'status')->dropDownList(
        [
            '0' => 'Открыт',
            '1' => 'Закрыт'
        ],
        ['style' => 'width: 200px;'] 
    ) ?>

    <?= $form->field($model, 'comment')->textarea(['rows' => 2]) ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? 'Создать' : 'Обновить', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>





































// I got the following line syntax from http://stackoverflow.com/questions/8554217/how-to-add-static-elements-to-yii-dropdownlist




<div class="row">

  <?php echo $form->labelEx($customers,'customer_name'); ?>

  <?php echo $form->dropdownList($customers,'customer_name',
								


                               array('someUniqueValue' => 'New Client') + CHtml::listData(Customers::model()->findAll(), 'id', 'customer_name'),

                                array('empty' => Yii::t('customers', 'Choose one'))

                            ); ?>

  <div id="newClientDialog"></div>

</div>
